#include "ioi2c.h"
#include "sys.h"
#include "delay.h"
  /**************************************************************************
ߣƽС֮
ҵԱС꣺http://shop114407458.taobao.com/
**************************************************************************/
/**************************ʵֺ********************************************
*ԭ:		void IIC_Init(void)
*:		ʼI2CӦĽӿš
*******************************************************************************/
void IIC_Init(void)
{			
	RCC->APB2ENR|=1<<3;//ʹIO PORTBʱ 							 
	GPIOB->CRH&=0XFFFFFF00;//PB8/9  
	GPIOB->CRH|=0X00000033;	   
}

/**************************ʵֺ********************************************
*ԭ:		void IIC_Start(void)
*:		IICʼź
*******************************************************************************/
int IIC_Start(void)
{
	SDA_OUT();     //sda
	IIC_SDA=1;
	if(!READ_SDA)return 0;	
	IIC_SCL=1;
	delay_us(1);
 	IIC_SDA=0;//START:when CLK is high,DATA change form high to low 
	if(READ_SDA)return 0;
	delay_us(1);
	IIC_SCL=0;//ǯסI2Cߣ׼ͻ 
	return 1;
}

/**************************ʵֺ********************************************
*ԭ:		void IIC_Stop(void)
*:	    //IICֹͣź
*******************************************************************************/	  
void IIC_Stop(void)
{
	SDA_OUT();//sda
	IIC_SCL=0;
	IIC_SDA=0;//STOP:when CLK is high DATA change form low to high
 	delay_us(1);
	IIC_SCL=1; 
	IIC_SDA=1;//I2C߽ź
	delay_us(1);							   	
}

/**************************ʵֺ********************************************
*ԭ:		u8 IIC_Wait_Ack(void)
*:	    ȴӦźŵ 
//ֵ1Ӧʧ
//        0Ӧɹ
*******************************************************************************/
int IIC_Wait_Ack(void)
{
	u8 ucErrTime=0;
	SDA_IN();      //SDAΪ  
	IIC_SDA=1;
	delay_us(1);	   
	IIC_SCL=1;
	delay_us(1);	 
	while(READ_SDA)
	{
		ucErrTime++;
		if(ucErrTime>50)
		{
			IIC_Stop();
			return 0;
		}
	  delay_us(1);
	}
	IIC_SCL=0;//ʱ0 	   
	return 1;  
} 

/**************************ʵֺ********************************************
*ԭ:		void IIC_Ack(void)
*:	    ACKӦ
*******************************************************************************/
void IIC_Ack(void)
{
	IIC_SCL=0;
	SDA_OUT();
	IIC_SDA=0;
	delay_us(1);
	IIC_SCL=1;
	delay_us(1);
	IIC_SCL=0;
}
	
/**************************ʵֺ********************************************
*ԭ:		void IIC_NAck(void)
*:	    NACKӦ
*******************************************************************************/	    
void IIC_NAck(void)
{
	IIC_SCL=0;
	SDA_OUT();
	IIC_SDA=1;
	delay_us(1);
	IIC_SCL=1;
	delay_us(1);
	IIC_SCL=0;
}
/**************************ʵֺ********************************************
*ԭ:		void IIC_Send_Byte(u8 txd)
*:	    IICһֽ
*******************************************************************************/		  
void IIC_Send_Byte(u8 txd)
{                        
    u8 t;   
	SDA_OUT(); 	    
    IIC_SCL=0;//ʱӿʼݴ
    for(t=0;t<8;t++)
    {              
        IIC_SDA=(txd&0x80)>>7;
        txd<<=1; 	  
		delay_us(1);   
		IIC_SCL=1;
		delay_us(1); 
		IIC_SCL=0;	
		delay_us(1);
    }	 
} 	 
  
/**************************ʵֺ********************************************
*ԭ:		bool i2cWrite(uint8_t addr, uint8_t reg, uint8_t data)
*:		
*******************************************************************************/
int i2cWrite(uint8_t addr, uint8_t reg, uint8_t len, uint8_t *data)
{
		int i;
    if (!IIC_Start())
        return 1;
    IIC_Send_Byte(addr << 1 );
    if (!IIC_Wait_Ack()) {
        IIC_Stop();
        return 1;
    }
    IIC_Send_Byte(reg);
    IIC_Wait_Ack();
		for (i = 0; i < len; i++) {
        IIC_Send_Byte(data[i]);
        if (!IIC_Wait_Ack()) {
            IIC_Stop();
            return 0;
        }
    }
    IIC_Stop();
    return 0;
}
/**************************ʵֺ********************************************
*ԭ:		bool i2cWrite(uint8_t addr, uint8_t reg, uint8_t data)
*:		
*******************************************************************************/
int i2cRead(uint8_t addr, uint8_t reg, uint8_t len, uint8_t *buf)
{
    if (!IIC_Start())
        return 1;
    IIC_Send_Byte(addr << 1);
    if (!IIC_Wait_Ack()) {
        IIC_Stop();
        return 1;
    }
    IIC_Send_Byte(reg);
    IIC_Wait_Ack();
    IIC_Start();
    IIC_Send_Byte((addr << 1)+1);
    IIC_Wait_Ack();
    while (len) {
        if (len == 1)
            *buf = IIC_Read_Byte(0);
        else
            *buf = IIC_Read_Byte(1);
        buf++;
        len--;
    }
    IIC_Stop();
    return 0;
}


/**************************ʵֺ********************************************
*ԭ:		u8 IIC_Read_Byte(unsigned char ack)
*:	    //1ֽڣack=1ʱACKack=0nACK 
*******************************************************************************/  
u8 IIC_Read_Byte(unsigned char ack)
{
	unsigned char i,receive=0;
	SDA_IN();//SDAΪ
    for(i=0;i<8;i++ )
	{
        IIC_SCL=0; 
        delay_us(2);
		IIC_SCL=1;
        receive<<=1;
        if(READ_SDA)receive++;   
		delay_us(2); 
    }					 
    if (ack)
        IIC_Ack(); //ACK 
    else
        IIC_NAck();//nACK  
    return receive;
}

/**************************ʵֺ********************************************
*ԭ:		unsigned char I2C_ReadOneByte(unsigned char I2C_Addr,unsigned char addr)
*:	    ȡָ豸 ָĴһֵ
	I2C_Addr  Ŀ豸ַ
		addr	   Ĵַ
   ֵ
*******************************************************************************/ 
unsigned char I2C_ReadOneByte(unsigned char I2C_Addr,unsigned char addr)
{
	unsigned char res=0;
	
	IIC_Start();	
	IIC_Send_Byte(I2C_Addr);	   //д
	res++;
	IIC_Wait_Ack();
	IIC_Send_Byte(addr); res++;  //͵ַ
	IIC_Wait_Ack();	  
	//IIC_Stop();//һֹͣ	
	IIC_Start();
	IIC_Send_Byte(I2C_Addr+1); res++;          //ģʽ			   
	IIC_Wait_Ack();
	res=IIC_Read_Byte(0);	   
    IIC_Stop();//һֹͣ

	return res;
}


/**************************ʵֺ********************************************
*ԭ:		u8 IICreadBytes(u8 dev, u8 reg, u8 length, u8 *data)
*:	    ȡָ豸 ָĴ lengthֵ
	dev  Ŀ豸ַ
		reg	  Ĵַ
		length Ҫֽ
		*data  ݽҪŵָ
   ֽ
*******************************************************************************/ 
u8 IICreadBytes(u8 dev, u8 reg, u8 length, u8 *data){
    u8 count = 0;
	
	IIC_Start();
	IIC_Send_Byte(dev);	   //д
	IIC_Wait_Ack();
	IIC_Send_Byte(reg);   //͵ַ
    IIC_Wait_Ack();	  
	IIC_Start();
	IIC_Send_Byte(dev+1);  //ģʽ	
	IIC_Wait_Ack();
	
    for(count=0;count<length;count++){
		 
		 if(count!=length-1)data[count]=IIC_Read_Byte(1);  //ACKĶ
		 	else  data[count]=IIC_Read_Byte(0);	 //һֽNACK
	}
    IIC_Stop();//һֹͣ
    return count;
}

/**************************ʵֺ********************************************
*ԭ:		u8 IICwriteBytes(u8 dev, u8 reg, u8 length, u8* data)
*:	    ֽдָ豸 ָĴ
	dev  Ŀ豸ַ
		reg	  Ĵַ
		length Ҫдֽ
		*data  Ҫдݵ׵ַ
   Ƿɹ
*******************************************************************************/ 
u8 IICwriteBytes(u8 dev, u8 reg, u8 length, u8* data){
  
 	u8 count = 0;
	IIC_Start();
	IIC_Send_Byte(dev);	   //д
	IIC_Wait_Ack();
	IIC_Send_Byte(reg);   //͵ַ
    IIC_Wait_Ack();	  
	for(count=0;count<length;count++){
		IIC_Send_Byte(data[count]); 
		IIC_Wait_Ack(); 
	 }
	IIC_Stop();//һֹͣ

    return 1; //status == 0;
}

/**************************ʵֺ********************************************
*ԭ:		u8 IICreadByte(u8 dev, u8 reg, u8 *data)
*:	    ȡָ豸 ָĴһֵ
	dev  Ŀ豸ַ
		reg	   Ĵַ
		*data  ݽҪŵĵַ
   1
*******************************************************************************/ 
u8 IICreadByte(u8 dev, u8 reg, u8 *data){
	*data=I2C_ReadOneByte(dev, reg);
    return 1;
}

/**************************ʵֺ********************************************
*ԭ:		unsigned char IICwriteByte(unsigned char dev, unsigned char reg, unsigned char data)
*:	    дָ豸 ָĴһֽ
	dev  Ŀ豸ַ
		reg	   Ĵַ
		data  Ҫдֽ
   1
*******************************************************************************/ 
unsigned char IICwriteByte(unsigned char dev, unsigned char reg, unsigned char data){
    return IICwriteBytes(dev, reg, 1, &data);
}

/**************************ʵֺ********************************************
*ԭ:		u8 IICwriteBits(u8 dev,u8 reg,u8 bitStart,u8 length,u8 data)
*:	     ޸ д ָ豸 ָĴһֽ еĶλ
	dev  Ŀ豸ַ
		reg	   Ĵַ
		bitStart  Ŀֽڵʼλ
		length   λ
		data    ŸıĿֽλֵ
   ɹ Ϊ1 
 		ʧΪ0
*******************************************************************************/ 
u8 IICwriteBits(u8 dev,u8 reg,u8 bitStart,u8 length,u8 data)
{

    u8 b;
    if (IICreadByte(dev, reg, &b) != 0) {
        u8 mask = (0xFF << (bitStart + 1)) | 0xFF >> ((8 - bitStart) + length - 1);
        data <<= (8 - length);
        data >>= (7 - bitStart);
        b &= mask;
        b |= data;
        return IICwriteByte(dev, reg, b);
    } else {
        return 0;
    }
}

/**************************ʵֺ********************************************
*ԭ:		u8 IICwriteBit(u8 dev, u8 reg, u8 bitNum, u8 data)
*:	     ޸ д ָ豸 ָĴһֽ е1λ
	dev  Ŀ豸ַ
		reg	   Ĵַ
		bitNum  Ҫ޸ĿֽڵbitNumλ
		data  Ϊ0 ʱĿλ0 򽫱λ
   ɹ Ϊ1 
 		ʧΪ0
*******************************************************************************/ 
u8 IICwriteBit(u8 dev, u8 reg, u8 bitNum, u8 data){
    u8 b;
    IICreadByte(dev, reg, &b);
    b = (data != 0) ? (b | (1 << bitNum)) : (b & ~(1 << bitNum));
    return IICwriteByte(dev, reg, b);
}

//------------------End of File----------------------------
